/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.platform;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.client.model.FoiledModel;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.render.ModelRenderer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jspecify.annotations.Nullable;

@AutoService(value={dan200.computercraft.impl.client.ClientPlatformHelper.class})
public class ClientPlatformHelperImpl
implements ClientPlatformHelper {
    private static final RandomSource random = RandomSource.create((long)0L);
    private static final Direction[] directions = Arrays.copyOf(Direction.values(), 7);

    @Override
    public BakedModel getModel(ModelManager manager, ResourceLocation resourceLocation) {
        return manager.getModel(ModelResourceLocation.standalone((ResourceLocation)resourceLocation));
    }

    @Override
    public BakedModel getModel(ModelManager manager, ModelResourceLocation modelLocation, @Nullable ResourceLocation resourceLocation) {
        return manager.getModel(modelLocation);
    }

    @Override
    public BakedModel createdFoiledModel(BakedModel model) {
        return new FoiledModel(model);
    }

    @Override
    public void renderBakedModel(PoseStack transform, MultiBufferSource buffers, BakedModel model, int lightmapCoord, int overlayLight, int @Nullable [] tints) {
        for (RenderType renderType : model.getRenderTypes(ItemStack.EMPTY, true)) {
            VertexConsumer buffer = buffers.getBuffer(renderType);
            for (Direction face : directions) {
                random.setSeed(42L);
                List quads = model.getQuads(null, face, random, ModelData.EMPTY, renderType);
                ModelRenderer.renderQuads(transform, buffer, quads, lightmapCoord, overlayLight, tints);
            }
        }
    }
}

